/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.desertmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAIBeg;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowParent;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIPlayerControl;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetParent;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.desertmobs.entity.EntityJoust;
import com.lycanitesmobs.desertmobs.entity.EntityJoustAlpha;
import com.lycanitesmobs.desertmobs.entity.EntityMudshot;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityErepede
extends EntityCreatureRideable
implements IGroupPredator {
    int difficultyUpdate = -1;

    public EntityErepede(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 2;
        this.experience = 5;
        this.hasAttackSound = false;
        this.setWidth = 0.8f;
        this.setHeight = 1.5f;
        this.attackTime = 10;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.isMobWhenNotTamed = true;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlayerControl(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("erepedetreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackRanged(this).setSpeed(0.75).setRate(40).setRange(14.0f).setMinChaseDistance(6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowParent(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBeg(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        if (MobInfo.predatorsAttackAnimals) {
            if (ObjectManager.getMob("Joust") != null) {
                this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityJoust.class).setPackHuntingScale(1, 3));
            }
            if (ObjectManager.getMob("JoustAlpha") != null) {
                this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityJoustAlpha.class).setPackHuntingScale(1, 1));
            }
        }
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetParent(this).setSightCheck(false).setDistance(32.0));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("movementSpeed", 0.26);
        baseAttributes.put("knockbackResistance", 0.25);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 0.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151145_ak), 1.0f).setMinAmount(1).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150366_p), 0.5f).setMinAmount(1).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("MudshotCharge")), 0.25f));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        if (rider.func_70644_a(MobEffects.field_76437_t)) {
            rider.func_184589_d(MobEffects.field_76437_t);
        }
        if (rider.func_70644_a(MobEffects.field_76438_s)) {
            rider.func_184589_d(MobEffects.field_76438_s);
        }
    }

    @Override
    public float getAISpeedModifier() {
        IBlockState blockState;
        if (this.hasRiderTarget() && ((blockState = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0))).func_185904_a() == Material.field_151595_p || blockState == Material.field_151579_a && this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -2, 0)).func_185904_a() == Material.field_151595_p)) {
            return 1.8f;
        }
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.9;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)rider;
            EntityMudshot projectile = new EntityMudshot(this.func_130014_f_(), (EntityLivingBase)player);
            this.func_130014_f_().func_72838_d((Entity)projectile);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.setJustAttacked();
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 5.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public void rangedAttack(Entity target, float range) {
        EntityMudshot projectile = new EntityMudshot(this.func_130014_f_(), (EntityLivingBase)this);
        projectile.setProjectileScale(2.0f);
        projectile.field_70163_u -= (double)(this.field_70131_O / 4.0f);
        float accuracy = 2.0f * (this.func_70681_au().nextFloat() - 0.5f);
        double d0 = target.field_70165_t - this.field_70165_t + (double)accuracy;
        double d1 = target.field_70163_u - (double)target.field_70131_O * 0.25 - projectile.field_70163_u + (double)accuracy;
        double d2 = target.field_70161_v - this.field_70161_v + (double)accuracy;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        float velocity = 1.2f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
        this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.func_130014_f_().func_72838_d((Entity)projectile);
        super.rangedAttack(target, range);
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 15;
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("cactus")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76438_s) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76437_t) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityErepede(this.func_130014_f_());
    }

    @Override
    public boolean isBreedingItem(ItemStack par1ItemStack) {
        return false;
    }

    @Override
    public boolean isTamingItem(ItemStack itemStack) {
        return itemStack.func_77973_b() == ObjectManager.getItem("erepedetreat");
    }

    @Override
    public void setTamed(boolean setTamed) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        super.setTamed(setTamed);
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }
}

